/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.autoplot.AddPlotsDialog;
import org.autoplot.ApplicationModel;
import org.autoplot.AutoRangeUtil;
import org.autoplot.AutoplotUtil;
import org.autoplot.BindToHiddenDialog;
import org.autoplot.GuiSupport;
import org.autoplot.PlotStylePanel;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.DataSourceEditorPanelUtil;
import org.autoplot.datasource.WindowManager;
import org.autoplot.dom.Annotation;
import org.autoplot.dom.Application;
import org.autoplot.dom.BindingModel;
import org.autoplot.dom.Column;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.dom.DomOps;
import org.autoplot.dom.DomUtil;
import org.autoplot.dom.Plot;
import org.autoplot.dom.PlotElement;
import org.autoplot.dom.PlotElementController;
import org.autoplot.dom.PlotElementStyle;
import org.autoplot.dom.Row;
import org.autoplot.help.AutoplotHelpSystem;
import org.autoplot.util.CanvasLayoutPanel;
import org.das2.components.propertyeditor.PropertyEditor;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasPlot;
import org.das2.graph.Renderer;
import org.das2.util.LoggerManager;
import org.jdesktop.layout.GroupLayout;

public class LayoutPanel
extends JPanel {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.gui.layout");
    private Plot draggingPlot = null;
    private Point dragInitialClick = null;
    private Point dragLocation = null;
    private Application dom;
    private ApplicationModel applicationModel;
    private boolean selectionChanged = false;
    private Map<Component, JPopupMenu> contextMenus = null;
    private Action removeBindingsAction = new AbstractAction("Remove Bindings"){

        @Override
        public void actionPerformed(ActionEvent e) {
            LoggerManager.logGuiEvent((ActionEvent)e);
            Plot domPlot = LayoutPanel.this.dom.getController().getPlot();
            List<PlotElement> elements = LayoutPanel.this.dom.getController().getPlotElementsFor(domPlot);
            for (PlotElement element : elements) {
                LayoutPanel.this.dom.getController().unbind(element);
            }
            LayoutPanel.this.dom.getController().unbind(domPlot);
        }
    };
    private Action deletePlotAction = new AbstractAction("Delete Plot"){

        @Override
        public void actionPerformed(ActionEvent e) {
            LoggerManager.logGuiEvent((ActionEvent)e);
            List<Object> os = LayoutPanel.this.canvasLayoutPanel1.getSelectedComponents();
            for (Object o : os) {
                if (LayoutPanel.this.dom.getPlots().length > 1) {
                    Plot domPlot = null;
                    if (o instanceof Component) {
                        domPlot = LayoutPanel.this.dom.getController().getPlotFor((Component)o);
                    }
                    if (domPlot == null) continue;
                    List<PlotElement> plotElements = LayoutPanel.this.dom.getController().getPlotElementsFor(domPlot);
                    for (PlotElement pan : plotElements) {
                        if (LayoutPanel.this.dom.getPlotElements().length > 1) {
                            LayoutPanel.this.dom.getController().deletePlotElement(pan);
                            continue;
                        }
                        LayoutPanel.this.dom.getController().setStatus("warning: the last plot element may not be deleted");
                    }
                    LayoutPanel.this.dom.getController().deletePlot(domPlot);
                    continue;
                }
                LayoutPanel.this.dom.getController().setStatus("warning: last plot may not be deleted");
            }
        }
    };
    private Action addPlotsAction = new AbstractAction("Add Plots..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            LoggerManager.logGuiEvent((ActionEvent)e);
            AddPlotsDialog dia = new AddPlotsDialog();
            dia.getNumberOfColumnsSpinner().setModel(new SpinnerNumberModel(1, 1, 6, 1));
            dia.getNumberOfRowsSpinner().setModel(new SpinnerNumberModel(1, 1, 6, 1));
            if (0 == WindowManager.showConfirmDialog((Component)LayoutPanel.this.plotElementListComponent, (Object)dia, (String)"Add Plots", (int)2, (int)-1, (Icon)new ImageIcon(AutoplotUtil.getAutoplotIcon()))) {
                int nr = (Integer)dia.getNumberOfRowsSpinner().getValue();
                int nc = (Integer)dia.getNumberOfColumnsSpinner().getValue();
                if (nr > 6 || nc > 6) {
                    AutoplotUtil.showMessageDialog(LayoutPanel.this, "No more than 6 rows or columns can be added at once.");
                } else {
                    Plot p = LayoutPanel.this.dom.getController().getPlot();
                    if (!p.getColumnId().equals(LayoutPanel.this.dom.getController().getCanvas().getMarginColumn().getId())) {
                        AutoplotUtil.showMessageDialog(dia, "plots can only be added when the plot column is the margin column");
                        return;
                    }
                    LayoutPanel.this.dom.getController().addPlots(nr, nc, dia.getDirection());
                    if (dia.getDirection() == null) {
                        LayoutPanel.this.dom.getController().deletePlot(p);
                    }
                }
            }
        }
    };
    private transient ListSelectionListener plotElementSelectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (LayoutPanel.this.plotElementListComponent.getValueIsAdjusting()) {
                return;
            }
            if (LayoutPanel.this.plotElementListComponent.getSelectedValuesList().size() == 1 && !LayoutPanel.this.dom.getController().isValueAdjusting()) {
                Object o = LayoutPanel.this.plotElementListComponent.getSelectedValue();
                if (!(o instanceof PlotElement)) {
                    System.err.println("expected plotElements in panelListComponent, returning");
                    return;
                }
                PlotElement pe = (PlotElement)o;
                Plot plot = LayoutPanel.this.dom.getController().getPlotFor(pe);
                if (plot != null) {
                    LayoutPanel.this.dom.getController().setPlot(plot);
                    LayoutPanel.this.dom.getController().setPlotElement(pe);
                    LayoutPanel.this.plotListComponent.setSelectedValue(plot, true);
                } else {
                    logger.fine("plot not found for plotElement");
                }
            }
        }
    };
    private transient PropertyChangeListener plotElementsListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LayoutPanel.this.updatePlotElementList();
        }
    };
    private transient PropertyChangeListener plotsListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LayoutPanel.this.updatePlotsList();
        }
    };
    private transient PropertyChangeListener bindingsListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LayoutPanel.this.updateBindingList();
        }
    };
    private transient PropertyChangeListener annotationsListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LayoutPanel.this.updateAnnotationsList();
        }
    };
    private transient PropertyChangeListener dataSourceListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LayoutPanel.this.dataSourceList.repaint();
        }
    };
    private transient PropertyChangeListener dataSourcesListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LayoutPanel.this.updateDataSourceList();
            DataSourceFilter[] old = (DataSourceFilter[])evt.getOldValue();
            DataSourceFilter[] nww = (DataSourceFilter[])evt.getNewValue();
            List<DataSourceFilter> oldList = Arrays.asList(old);
            for (DataSourceFilter dsf : nww) {
                if (oldList.contains(dsf)) continue;
                dsf.addPropertyChangeListener("uri", LayoutPanel.this.dataSourceListener);
                dsf.getController().addPropertyChangeListener("tsb", LayoutPanel.this.dataSourceListener);
            }
            List<DataSourceFilter> newList = Arrays.asList(nww);
            for (DataSourceFilter dsf : old) {
                if (newList.contains(dsf)) continue;
                dsf.removePropertyChangeListener("uri", LayoutPanel.this.dataSourceListener);
                dsf.getController().removePropertyChangeListener("tsb", LayoutPanel.this.dataSourceListener);
            }
        }
    };
    private transient PropertyChangeListener plotListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Plot plot = LayoutPanel.this.dom.getController().getPlot();
            if (plot == null) {
                return;
            }
            List<PlotElement> p = LayoutPanel.this.dom.getController().getPlotElementsFor(plot);
            List<PlotElement> allElements = Arrays.asList(LayoutPanel.this.dom.getPlotElements());
            ArrayList<Integer> indices = new ArrayList<Integer>();
            for (int i = 0; i < p.size(); ++i) {
                if (!p.get(i).isActive()) continue;
                indices.add(allElements.indexOf(p.get(i)));
            }
            final int[] iindices = new int[indices.size()];
            for (int i = 0; i < indices.size(); ++i) {
                iindices[i] = (Integer)indices.get(i);
            }
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    logger.finer("enter plotListener");
                    LayoutPanel.this.plotElementListComponent.setSelectedIndices(iindices);
                    LayoutPanel.this.selectionChanged = true;
                    LayoutPanel.this.updatePlotsList();
                    LayoutPanel.this.repaint();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                run.run();
            } else {
                SwingUtilities.invokeLater(run);
            }
        }
    };
    private transient PropertyChangeListener plotElementListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PlotElement p = LayoutPanel.this.dom.getController().getPlotElement();
            List<PlotElement> allElements = Arrays.asList(LayoutPanel.this.dom.getPlotElements());
            final int index = allElements.indexOf(p);
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    LayoutPanel.this.plotElementListComponent.setSelectedIndex(index);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                run.run();
            } else {
                SwingUtilities.invokeLater(run);
            }
        }
    };
    private ListCellRenderer plotElementListCellRenderer = new DefaultListCellRenderer(){

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Renderer rend;
            PlotElementController cont;
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            PlotElement val = (PlotElement)value;
            if (val != null && (cont = val.getController()) != null && (rend = val.getController().getRenderer()) != null) {
                Icon icon = rend.getListIcon();
                label.setIcon(icon);
            }
            return label;
        }
    };
    private static final ImageIcon blueIcon = new ImageIcon(LayoutPanel.class.getResource("/resources/blue.gif"));
    private static final ImageIcon idleIcon = new ImageIcon(LayoutPanel.class.getResource("/org/autoplot/resources/idle-icon.png"));
    ListCellRenderer dsfListCellRenderer = new DefaultListCellRenderer(){

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel l = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            DataSourceFilter dsf = (DataSourceFilter)value;
            if (dsf.getController().getTsb() != null) {
                l.setIcon(blueIcon);
                l.setToolTipText("<html>" + dsf.getUri() + "<br>Data source provides Time Series Browsing");
            } else {
                l.setIcon(idleIcon);
                if (dsf.getUri().length() == 0) {
                    l.setToolTipText(null);
                } else {
                    l.setToolTipText("<html>" + dsf.getUri());
                }
            }
            return l;
        }
    };
    private JMenuItem addHiddenMenuItem;
    private JMenuItem addPlotsBelowMenuItem;
    private JButton addPlotsButton;
    private JPopupMenu annotationsActionsMenu;
    private JList<String> annotationsListComponent;
    private JMenuItem biggerMI;
    private JPopupMenu bindingActionsMenu;
    private JList bindingListComponent;
    private CanvasLayoutPanel canvasLayoutPanel1;
    private JPopupMenu dataSourceActionsMenu;
    private JList<String> dataSourceList;
    private JMenuItem deleteAnnotationsMenuItem;
    private JMenuItem deleteBindingsMenuItem;
    private JMenuItem deleteMenuItem;
    private JButton deletePlotButton;
    private JMenuItem editAnnotationsMenuItem;
    private JMenuItem editMenuItem;
    private JButton fixLayoutButton;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JSplitPane jSplitPane3;
    private JTabbedPane jTabbedPane1;
    private JTable jTable1;
    private JPopupMenu plotActionsMenu;
    private JList plotElementListComponent;
    private JList<Plot> plotListComponent;
    private JMenu plotMenu;
    private JPanel plotsListPanel;
    private JMenu plotsMenu;
    private JMenuItem propertiesMenuItem;
    private JMenuItem removeBindingsMenuItem;
    private JButton sameHeightButton;
    private JMenuItem sameSizeMI;
    private JLabel selectedPlotLabel;
    private JMenuItem setHeightMI;
    private JButton shorterButton;
    private JMenu sizeMenu;
    private JMenuItem smallerMI;
    private JMenuItem swapMenuItem;
    private JButton tallerButton;

    public LayoutPanel() {
        this.initComponents();
        this.canvasLayoutPanel1.addPropertyChangeListener("component", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String selectText;
                Plot plot = LayoutPanel.this.dom.getController().getPlotFor((Component)LayoutPanel.this.canvasLayoutPanel1.getComponent());
                List<Object> p = LayoutPanel.this.canvasLayoutPanel1.getSelectedComponents();
                if (plot != null) {
                    LayoutPanel.this.dom.getController().setPlot(plot);
                    LayoutPanel.this.canvasLayoutPanel1.setSelectedComponents(p);
                }
                LayoutPanel.this.tallerButton.setEnabled(plot != null);
                LayoutPanel.this.shorterButton.setEnabled(plot != null);
                LayoutPanel.this.addPlotsButton.setEnabled(plot != null);
                LayoutPanel.this.addPlotsButton.setEnabled(plot != null);
                int count = LayoutPanel.this.getSelectedPlots().size();
                LayoutPanel.this.sameHeightButton.setEnabled(count > 1);
                switch (count) {
                    case 1: {
                        if (plot != null) {
                            selectText = plot.getId();
                            break;
                        }
                        selectText = "";
                        break;
                    }
                    default: {
                        selectText = String.format("%d plots selected", count);
                    }
                }
                LayoutPanel.this.selectedPlotLabel.setText(selectText);
            }
        });
        this.plotElementListComponent.addListSelectionListener(this.plotElementSelectionListener);
        this.canvasLayoutPanel1.addPropertyChangeListener("selectedComponents", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String selectText;
                List<Plot> selectedPlots = LayoutPanel.this.getSelectedPlots();
                int count = selectedPlots.size();
                LayoutPanel.this.sameHeightButton.setEnabled(count > 1);
                switch (count) {
                    case 1: {
                        if (selectedPlots.get(0) != null) {
                            selectText = selectedPlots.get(0).getId();
                            break;
                        }
                        selectText = "";
                        break;
                    }
                    default: {
                        selectText = String.format("%d plots selected", count);
                    }
                }
                LayoutPanel.this.selectedPlotLabel.setText(selectText);
                LayoutPanel.this.dom.getController().setSelectedPlotsArray(selectedPlots.toArray(new Plot[selectedPlots.size()]));
            }
        });
        this.createPopupMenus();
        MouseListener popupTrigger = this.createPopupTrigger();
        this.canvasLayoutPanel1.addMouseListener(popupTrigger);
        this.canvasLayoutPanel1.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Object s;
                if (LayoutPanel.this.draggingPlot == null && LayoutPanel.this.dragInitialClick == null) {
                    Object s2 = LayoutPanel.this.canvasLayoutPanel1.getCanvasComponentAt(e.getX(), e.getY());
                    if (s2 instanceof Component) {
                        LayoutPanel.this.draggingPlot = LayoutPanel.this.dom.getController().getPlotFor((Component)s2);
                        LayoutPanel.this.setCursor(Cursor.getPredefinedCursor(13));
                        LayoutPanel.this.dom.getController().setStatus("swap " + LayoutPanel.this.draggingPlot + ", drop to swap positions.");
                    } else {
                        LayoutPanel.this.dragInitialClick = e.getPoint();
                        LayoutPanel.this.dom.getController().setStatus("select plots by drawing a box.");
                    }
                    LayoutPanel.this.canvasLayoutPanel1.setRectangleSelect(null);
                } else if (LayoutPanel.this.dragInitialClick != null) {
                    LayoutPanel.this.dragLocation = e.getPoint();
                    Rectangle rect = new Rectangle(LayoutPanel.this.dragInitialClick);
                    rect.add(e.getPoint());
                    LayoutPanel.this.canvasLayoutPanel1.setSelectedComponents(rect);
                    LayoutPanel.this.canvasLayoutPanel1.setRectangleSelect(rect);
                    int count = LayoutPanel.this.getSelectedPlots().size();
                    LayoutPanel.this.sameHeightButton.setEnabled(count > 1);
                } else if (LayoutPanel.this.draggingPlot != null && (s = LayoutPanel.this.canvasLayoutPanel1.getCanvasComponentAt(e.getX(), e.getY())) instanceof Component) {
                    Plot targetPlot = LayoutPanel.this.dom.getController().getPlotFor((Component)s);
                    if (targetPlot != null && targetPlot != LayoutPanel.this.draggingPlot) {
                        LayoutPanel.this.dom.getController().setStatus("swap " + LayoutPanel.this.draggingPlot + " and " + targetPlot);
                    } else {
                        LayoutPanel.this.dom.getController().setStatus("swap " + LayoutPanel.this.draggingPlot + ", drop to swap positions.");
                    }
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        this.plotElementListComponent.addMouseListener(popupTrigger);
        this.dataSourceList.addMouseListener(popupTrigger);
        this.bindingListComponent.addMouseListener(popupTrigger);
        this.annotationsListComponent.addMouseListener(popupTrigger);
        this.plotListComponent.addMouseListener(popupTrigger);
        AutoplotHelpSystem.getHelpSystem().registerHelpID((Component)this, "layoutPanel");
    }

    private static void assertEventThread(String caller) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalArgumentException(caller + " must be called from the event thread.");
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.selectionChanged) {
            this.updateSelected();
            this.selectionChanged = false;
        }
        super.paint(g);
    }

    private MouseListener createPopupTrigger() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JPopupMenu menu;
                if (e.isPopupTrigger() && (menu = (JPopupMenu)LayoutPanel.this.contextMenus.get(e.getComponent())) != null) {
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
                LayoutPanel.this.canvasLayoutPanel1.setRectangleSelect(null);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JPopupMenu menu;
                if (e.isPopupTrigger() && (menu = (JPopupMenu)LayoutPanel.this.contextMenus.get(e.getComponent())) != null) {
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
                if (LayoutPanel.this.draggingPlot != null) {
                    Plot targetPlot;
                    Object s = LayoutPanel.this.canvasLayoutPanel1.getCanvasComponentAt(e.getX(), e.getY());
                    if (s instanceof Component && (targetPlot = LayoutPanel.this.dom.getController().getPlotFor((Component)s)) != null) {
                        DomOps.swapPosition(LayoutPanel.this.draggingPlot, targetPlot);
                        if (LayoutPanel.this.dom.getOptions().isAutolayout()) {
                            DomOps.newCanvasLayout(LayoutPanel.this.dom);
                        }
                        LayoutPanel.this.dom.getController().setStatus("swapped " + LayoutPanel.this.draggingPlot + " and " + targetPlot);
                    }
                    LayoutPanel.this.setCursor(null);
                    LayoutPanel.this.draggingPlot = null;
                }
                if (LayoutPanel.this.dragInitialClick != null) {
                    Rectangle rect = new Rectangle(LayoutPanel.this.dragInitialClick);
                    rect.add(e.getPoint());
                    LayoutPanel.this.canvasLayoutPanel1.setSelectedComponents(rect);
                    LayoutPanel.this.dragInitialClick = null;
                }
                LayoutPanel.this.canvasLayoutPanel1.setRectangleSelect(null);
            }
        };
    }

    public void setApplicationModel(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    private void createPopupMenus() {
        LayoutPanel.assertEventThread("createPopupMenus");
        this.contextMenus = new HashMap<Component, JPopupMenu>();
        this.contextMenus.put(this.canvasLayoutPanel1, this.plotActionsMenu);
        this.contextMenus.put(this.dataSourceList, this.dataSourceActionsMenu);
        this.contextMenus.put(this.plotListComponent, this.plotActionsMenu);
        JPopupMenu plotElementContextMenu = new JPopupMenu();
        JMenuItem item = new JMenuItem(new AbstractAction("Edit Plot Element Properties"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertyEditor edit;
                LoggerManager.logGuiEvent((ActionEvent)e);
                List os = LayoutPanel.this.plotElementListComponent.getSelectedValuesList();
                PlotElement p = (PlotElement)LayoutPanel.this.plotElementListComponent.getSelectedValue();
                switch (os.size()) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        edit = new PropertyEditor((Object)p);
                        break;
                    }
                    default: {
                        Object[] peers = new PlotElement[os.size()];
                        os.toArray(peers);
                        edit = PropertyEditor.createPeersEditor((Object)p, (Object[])peers);
                    }
                }
                edit.showDialog((Component)LayoutPanel.this);
            }
        });
        item.setToolTipText("edit the plot element or elements");
        plotElementContextMenu.add(item);
        item = new JMenuItem(new AbstractAction("Edit Plot Element Style Properties"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                List os = LayoutPanel.this.plotElementListComponent.getSelectedValuesList();
                PlotElement p = (PlotElement)LayoutPanel.this.plotElementListComponent.getSelectedValue();
                if (os.size() == 1) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    PlotStylePanel.StylePanel editorPanel = GuiSupport.getStylePanel(p.getRenderType());
                    editorPanel.doElementBindings(p);
                    PlotElement oldp = (PlotElement)p.copy();
                    if (2 == AutoplotUtil.showConfirmDialog(LayoutPanel.this, editorPanel, (Object)((Object)p.getRenderType()) + " Style", 2)) {
                        p.syncTo(oldp);
                    }
                } else if (os.size() > 1) {
                    Object[] peers = new PlotElementStyle[os.size()];
                    for (int i = 0; i < os.size(); ++i) {
                        peers[i] = ((PlotElement)os.get(i)).getStyle();
                    }
                    PropertyEditor edit = PropertyEditor.createPeersEditor((Object)p.getStyle(), (Object[])peers);
                    edit.showDialog((Component)LayoutPanel.this);
                }
            }
        });
        item.setToolTipText("edit the style of plot element or elements");
        plotElementContextMenu.add(item);
        item = new JMenuItem(new AbstractAction("Delete Plot Element"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                List os = LayoutPanel.this.plotElementListComponent.getSelectedValuesList();
                for (Object o : os) {
                    PlotElement element = (PlotElement)o;
                    LayoutPanel.this.dom.getController().deletePlotElement(element);
                }
            }
        });
        plotElementContextMenu.add(item);
        item = new JMenuItem(new AbstractAction("Move Plot Element Above Others"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                ArrayList<PlotElement> pes = new ArrayList<PlotElement>();
                List os = LayoutPanel.this.plotElementListComponent.getSelectedValuesList();
                for (Object o : os) {
                    PlotElement element = (PlotElement)o;
                    pes.add(element);
                }
                for (PlotElement pe : pes) {
                    Plot p = LayoutPanel.this.dom.getController().getPlotFor(pe);
                    p.getController().toTop(pe);
                }
            }
        });
        plotElementContextMenu.add(item);
        item = new JMenuItem(new AbstractAction("Blur Focus"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                LayoutPanel.this.dom.getController().setPlotElement(null);
                LayoutPanel.this.plotElementListComponent.setSelectedIndices(new int[0]);
            }
        });
        plotElementContextMenu.add(item);
        this.contextMenus.put(this.plotElementListComponent, plotElementContextMenu);
        this.contextMenus.put(this.bindingListComponent, this.bindingActionsMenu);
        this.contextMenus.put(this.annotationsListComponent, this.annotationsActionsMenu);
    }

    private void updateSelected() {
        int[] iindices = this.plotElementListComponent.getSelectedIndices();
        PlotElement[] peles = this.dom.getPlotElements();
        ArrayList<Object> selected = new ArrayList<Object>();
        DasPlot dasPlot = null;
        Plot plot = this.dom.getController().getPlot();
        if (plot != null) {
            dasPlot = plot.getController().getDasPlot();
            selected.add(dasPlot);
            ArrayList<DataSourceFilter> dsfs = new ArrayList<DataSourceFilter>();
            ArrayList<Plot> plots = new ArrayList<Plot>();
            for (int i = 0; i < iindices.length; ++i) {
                try {
                    PlotElementController pec = peles[iindices[i]].getController();
                    selected.add(pec.getRenderer());
                    dsfs.add((DataSourceFilter)DomUtil.getElementById(this.dom, pec.getPlotElement().getDataSourceFilterId()));
                    Plot pp = (Plot)DomUtil.getElementById(this.dom, pec.getPlotElement().getPlotId());
                    if (!plots.contains(pp)) {
                        plots.add(pp);
                    }
                    if (dsfs.size() <= 0) continue;
                    this.dataSourceList.setSelectedValue(dsfs.get(0), true);
                    continue;
                }
                catch (IndexOutOfBoundsException ex) {
                    System.err.println("harmless indexOutOfBoundsException needs to be fixed sometime");
                }
            }
            this.dom.getController().setSelectedPlotsArray(plots.toArray(new Plot[plots.size()]));
        } else {
            this.dom.getController().setSelectedPlots("");
        }
        this.canvasLayoutPanel1.setSelectedComponents(selected);
        this.canvasLayoutPanel1.setComponent(dasPlot);
        this.deletePlotAction.setEnabled(true);
        this.tallerButton.setEnabled(true);
        this.shorterButton.setEnabled(true);
        this.sameHeightButton.setEnabled(true);
    }

    public void setApplication(Application dom) {
        this.dom = dom;
        this.updatePlotElementList();
        this.updateBindingList();
        this.updateAnnotationsList();
        this.updateDataSourceList();
        this.updatePlotsList();
        this.canvasLayoutPanel1.setContainer(dom.getController().getDasCanvas());
        dom.getController().getDasCanvas().addPropertyChangeListener("paintCount", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                LayoutPanel.this.plotElementListComponent.repaint();
            }
        });
        this.canvasLayoutPanel1.addComponentType(DasPlot.class, Color.BLUE);
        dom.getController().bind(dom.getOptions(), "background", this.canvasLayoutPanel1, "background");
        dom.addPropertyChangeListener("plotElements", this.plotElementsListener);
        dom.addPropertyChangeListener("plots", this.plotsListener);
        dom.addPropertyChangeListener("bindings", this.bindingsListener);
        dom.addPropertyChangeListener("annotations", this.annotationsListener);
        dom.addPropertyChangeListener("dataSourceFilters", this.dataSourcesListener);
        dom.getController().addPropertyChangeListener("plot", this.plotListener);
        dom.getController().addPropertyChangeListener("plotElement", this.plotElementListener);
        for (DataSourceFilter dsf : dom.getDataSourceFilters()) {
            dsf.addPropertyChangeListener("uri", this.dataSourceListener);
            dsf.getController().addPropertyChangeListener("tsb", this.dataSourceListener);
        }
    }

    private void updatePlotElementListImmediately() {
        final Object[] foo = this.dom.getPlotElements();
        AbstractListModel elementsList = new AbstractListModel(){

            @Override
            public int getSize() {
                return foo.length;
            }

            @Override
            public Object getElementAt(int index) {
                return foo[index];
            }
        };
        this.plotElementListComponent.removeAll();
        this.plotElementListComponent.setModel(elementsList);
        this.plotElementListComponent.setCellRenderer(this.plotElementListCellRenderer);
    }

    private void updatePlotElementList() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                LayoutPanel.this.updatePlotElementListImmediately();
            }
        };
        SwingUtilities.invokeLater(run);
    }

    private static List getSublist(List list, Comparator c, Object equalTo) {
        ArrayList result = new ArrayList(list.size());
        for (Object o : list) {
            if (c.compare(o, equalTo) != 0) continue;
            result.add(o);
        }
        return result;
    }

    private void updateBindingList() {
        final ArrayList<BindingModel> bindingList = new ArrayList<BindingModel>(Arrays.asList(this.dom.getBindings()));
        List rm = LayoutPanel.getSublist(bindingList, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((BindingModel)o1).getDstProperty().equals("colortable") ? 0 : 1;
            }
        }, null);
        bindingList.removeAll(rm);
        AbstractListModel elementsList = new AbstractListModel(){

            @Override
            public int getSize() {
                return bindingList.size();
            }

            @Override
            public Object getElementAt(int index) {
                return bindingList.get(index);
            }
        };
        this.bindingListComponent.setModel(elementsList);
        this.bindingListComponent.repaint();
    }

    private void updateAnnotationsList() {
        final ArrayList<Annotation> annotations = new ArrayList<Annotation>(Arrays.asList(this.dom.getAnnotations()));
        AbstractListModel elementsList = new AbstractListModel(){

            @Override
            public int getSize() {
                return annotations.size();
            }

            @Override
            public Object getElementAt(int index) {
                return annotations.get(index);
            }
        };
        this.annotationsListComponent.setModel(elementsList);
        this.annotationsListComponent.repaint();
    }

    private void updatePlotsList() {
        final ArrayList<Plot> plots = new ArrayList<Plot>(Arrays.asList(this.dom.getPlots()));
        AbstractListModel elementsList = new AbstractListModel(){

            @Override
            public int getSize() {
                return plots.size();
            }

            @Override
            public Object getElementAt(int index) {
                return plots.get(index);
            }
        };
        this.plotListComponent.setModel(elementsList);
        this.plotListComponent.setSelectedValue(this.dom.getController().getPlot(), true);
        this.plotListComponent.repaint();
    }

    private void updateDataSourceList() {
        ArrayList<DataSourceFilter> list = new ArrayList<DataSourceFilter>(Arrays.asList(this.dom.getDataSourceFilters()));
        DefaultListModel<DataSourceFilter> elementsList = new DefaultListModel<DataSourceFilter>();
        for (DataSourceFilter dsf : list) {
            elementsList.addElement(dsf);
        }
        this.dataSourceList.setCellRenderer(this.dsfListCellRenderer);
        this.dataSourceList.setModel(elementsList);
        this.dataSourceList.repaint();
    }

    public List<Plot> getSelectedPlots() {
        Plot domPlot;
        List<Object> os = this.canvasLayoutPanel1.getSelectedComponents();
        ArrayList<Plot> result = new ArrayList<Plot>();
        for (Object o : os) {
            if (this.dom.getPlots().length <= 1) continue;
            Plot domPlot2 = null;
            if (o instanceof Component) {
                domPlot2 = this.dom.getController().getPlotFor((Component)o);
            }
            if (domPlot2 == null) continue;
            result.add(domPlot2);
        }
        Object o = this.canvasLayoutPanel1.getComponent();
        if (o instanceof Component && (domPlot = this.dom.getController().getPlotFor((Component)o)) != null) {
            result.remove(domPlot);
            result.add(0, domPlot);
        }
        return result;
    }

    private void initComponents() {
        this.plotActionsMenu = new JPopupMenu();
        this.plotMenu = new JMenu();
        this.propertiesMenuItem = new JMenuItem();
        this.deleteMenuItem = new JMenuItem(this.deletePlotAction);
        this.addPlotsBelowMenuItem = new JMenuItem(this.addPlotsAction);
        this.removeBindingsMenuItem = new JMenuItem(this.removeBindingsAction);
        this.plotsMenu = new JMenu();
        this.sizeMenu = new JMenu();
        this.biggerMI = new JMenuItem();
        this.smallerMI = new JMenuItem();
        this.sameSizeMI = new JMenuItem();
        this.setHeightMI = new JMenuItem();
        this.swapMenuItem = new JMenuItem();
        this.addHiddenMenuItem = new JMenuItem();
        this.bindingActionsMenu = new JPopupMenu();
        this.deleteBindingsMenuItem = new JMenuItem();
        this.jScrollPane3 = new JScrollPane();
        this.jTable1 = new JTable();
        this.dataSourceActionsMenu = new JPopupMenu();
        this.editMenuItem = new JMenuItem();
        this.annotationsActionsMenu = new JPopupMenu();
        this.deleteAnnotationsMenuItem = new JMenuItem();
        this.editAnnotationsMenuItem = new JMenuItem();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.jSplitPane3 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.plotElementListComponent = new JList();
        this.jPanel4 = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.dataSourceList = new JList();
        this.jSplitPane2 = new JSplitPane();
        this.jPanel3 = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel6 = new JPanel();
        this.jScrollPane5 = new JScrollPane();
        this.annotationsListComponent = new JList();
        this.jPanel5 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.bindingListComponent = new JList();
        this.plotsListPanel = new JPanel();
        this.jScrollPane6 = new JScrollPane();
        this.plotListComponent = new JList();
        this.jPanel1 = new JPanel();
        this.canvasLayoutPanel1 = new CanvasLayoutPanel();
        this.tallerButton = new JButton();
        this.shorterButton = new JButton();
        this.sameHeightButton = new JButton();
        this.addPlotsButton = new JButton();
        this.fixLayoutButton = new JButton();
        this.deletePlotButton = new JButton();
        this.selectedPlotLabel = new JLabel();
        this.plotMenu.setText("Plot");
        this.propertiesMenuItem.setText("Properties...");
        this.propertiesMenuItem.setToolTipText("edit plot properties");
        this.propertiesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.propertiesMenuItemActionPerformed(evt);
            }
        });
        this.plotMenu.add(this.propertiesMenuItem);
        this.deleteMenuItem.setText("Delete");
        this.plotMenu.add(this.deleteMenuItem);
        this.addPlotsBelowMenuItem.setText("Add Plots...");
        this.addPlotsBelowMenuItem.setToolTipText("Add a grid of plots below or above the selected plot");
        this.addPlotsBelowMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.addPlotsBelowMenuItemActionPerformed(evt);
            }
        });
        this.plotMenu.add(this.addPlotsBelowMenuItem);
        this.removeBindingsMenuItem.setText("Remove Bindings");
        this.removeBindingsMenuItem.setToolTipText("Remove bindings to other parts of the application");
        this.plotMenu.add(this.removeBindingsMenuItem);
        this.plotActionsMenu.add(this.plotMenu);
        this.plotsMenu.setText("Canvas");
        this.sizeMenu.setText("Plot Size");
        this.sizeMenu.setToolTipText("Adjust the selected plots' size");
        this.biggerMI.setText("Taller");
        this.biggerMI.setToolTipText("Make the selected plots 25% taller relative to others");
        this.biggerMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.biggerMIActionPerformed(evt);
            }
        });
        this.sizeMenu.add(this.biggerMI);
        this.smallerMI.setText("Shorter");
        this.smallerMI.setToolTipText("Make the selected plots 25% shorter relative to others");
        this.smallerMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.smallerMIActionPerformed(evt);
            }
        });
        this.sizeMenu.add(this.smallerMI);
        this.sameSizeMI.setText("Same Height");
        this.sameSizeMI.setToolTipText("Make the selected plots have the same height");
        this.sameSizeMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.sameSizeMIActionPerformed(evt);
            }
        });
        this.sizeMenu.add(this.sameSizeMI);
        this.setHeightMI.setText("Set Height to 1em");
        this.setHeightMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.setHeightMIActionPerformed(evt);
            }
        });
        this.sizeMenu.add(this.setHeightMI);
        this.plotsMenu.add(this.sizeMenu);
        this.swapMenuItem.setText("Swap Position");
        this.swapMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.swapMenuItemActionPerformed(evt);
            }
        });
        this.plotsMenu.add(this.swapMenuItem);
        this.addHiddenMenuItem.setText("Add Hidden Plot...");
        this.addHiddenMenuItem.setToolTipText("Add hidden plot for this plot/plots to bind plots together.\n");
        this.addHiddenMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.addHiddenMenuItemActionPerformed(evt);
            }
        });
        this.plotsMenu.add(this.addHiddenMenuItem);
        this.plotActionsMenu.add(this.plotsMenu);
        this.bindingActionsMenu.setToolTipText("Binding actions");
        this.deleteBindingsMenuItem.setText("Delete Selected Bindings");
        this.deleteBindingsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.deleteBindingsMenuItemActionPerformed(evt);
            }
        });
        this.bindingActionsMenu.add(this.deleteBindingsMenuItem);
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane3.setViewportView(this.jTable1);
        this.editMenuItem.setText("Edit");
        this.editMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.editMenuItemActionPerformed(evt);
            }
        });
        this.dataSourceActionsMenu.add(this.editMenuItem);
        this.annotationsActionsMenu.setToolTipText("Binding actions");
        this.deleteAnnotationsMenuItem.setText("Delete Selected Annotations");
        this.deleteAnnotationsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.deleteAnnotationsMenuItemActionPerformed(evt);
            }
        });
        this.annotationsActionsMenu.add(this.deleteAnnotationsMenuItem);
        this.editAnnotationsMenuItem.setText("Edit Annotation(s)");
        this.editAnnotationsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.editAnnotationsMenuItemActionPerformed(evt);
            }
        });
        this.annotationsActionsMenu.add(this.editAnnotationsMenuItem);
        this.jSplitPane1.setDividerLocation(330);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Plot Elements [?]"));
        this.jPanel2.setToolTipText("List of plot elements (renderings of data) on the canvas");
        this.jSplitPane3.setDividerLocation(370);
        this.jSplitPane3.setOrientation(0);
        this.plotElementListComponent.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.plotElementListComponent.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                LayoutPanel.this.plotElementListComponentValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.plotElementListComponent);
        this.jSplitPane3.setTopComponent(this.jScrollPane1);
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Data Sources"));
        this.dataSourceList.setFont(this.dataSourceList.getFont().deriveFont((float)this.dataSourceList.getFont().getSize() - 2.0f));
        this.dataSourceList.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.dataSourceList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                LayoutPanel.this.dataSourceListValueChanged(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.dataSourceList);
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((Component)this.jScrollPane4, -1, 343, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add(2, (Component)this.jScrollPane4, -1, 63, Short.MAX_VALUE));
        this.jSplitPane3.setRightComponent(this.jPanel4);
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jSplitPane3));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (Component)this.jSplitPane3, -1, 461, Short.MAX_VALUE));
        this.jSplitPane1.setRightComponent(this.jPanel2);
        this.jSplitPane2.setDividerLocation(370);
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane2.setResizeWeight(0.5);
        this.jPanel3.setToolTipText("List of connections between DOM properties");
        this.annotationsListComponent.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane5.setViewportView(this.annotationsListComponent);
        GroupLayout jPanel6Layout = new GroupLayout((Container)this.jPanel6);
        this.jPanel6.setLayout((LayoutManager)jPanel6Layout);
        jPanel6Layout.setHorizontalGroup((GroupLayout.Group)jPanel6Layout.createParallelGroup(1).add((Component)this.jScrollPane5, -1, 330, Short.MAX_VALUE));
        jPanel6Layout.setVerticalGroup((GroupLayout.Group)jPanel6Layout.createParallelGroup(1).add((Component)this.jScrollPane5, -1, 219, Short.MAX_VALUE));
        this.jTabbedPane1.addTab("Annotations", this.jPanel6);
        this.bindingListComponent.setFont(this.bindingListComponent.getFont().deriveFont((float)this.bindingListComponent.getFont().getSize() - 2.0f));
        this.bindingListComponent.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane2.setViewportView(this.bindingListComponent);
        GroupLayout jPanel5Layout = new GroupLayout((Container)this.jPanel5);
        this.jPanel5.setLayout((LayoutManager)jPanel5Layout);
        jPanel5Layout.setHorizontalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add(0, 330, Short.MAX_VALUE).add((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((Component)this.jScrollPane2, -1, 330, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add(0, 219, Short.MAX_VALUE).add((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add(2, (Component)this.jScrollPane2, -1, 219, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Bindings", this.jPanel5);
        this.plotListComponent.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                LayoutPanel.this.plotListComponentValueChanged(evt);
            }
        });
        this.jScrollPane6.setViewportView(this.plotListComponent);
        GroupLayout plotsListPanelLayout = new GroupLayout((Container)this.plotsListPanel);
        this.plotsListPanel.setLayout((LayoutManager)plotsListPanelLayout);
        plotsListPanelLayout.setHorizontalGroup((GroupLayout.Group)plotsListPanelLayout.createParallelGroup(1).add((Component)this.jScrollPane6, -1, 330, Short.MAX_VALUE));
        plotsListPanelLayout.setVerticalGroup((GroupLayout.Group)plotsListPanelLayout.createParallelGroup(1).add((Component)this.jScrollPane6, -1, 219, Short.MAX_VALUE));
        this.jTabbedPane1.addTab("Plots", this.plotsListPanel);
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jTabbedPane1));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jTabbedPane1));
        this.jSplitPane2.setRightComponent(this.jPanel3);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Plots [?]"));
        this.jPanel1.setToolTipText("<html>Layout of plots on the canvas<br>Click for help");
        this.jPanel1.setMinimumSize(new Dimension(230, 230));
        this.canvasLayoutPanel1.setText("canvasLayoutPanel1");
        this.tallerButton.setText("Taller");
        this.tallerButton.setToolTipText("Make the selected plots taller");
        this.tallerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.tallerButtonActionPerformed(evt);
            }
        });
        this.shorterButton.setText("Shorter");
        this.shorterButton.setToolTipText("Make the selected plots shorter");
        this.shorterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.shorterButtonActionPerformed(evt);
            }
        });
        this.sameHeightButton.setText("Same Height");
        this.sameHeightButton.setToolTipText("Make the selected plots the same height");
        this.sameHeightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.sameHeightButtonActionPerformed(evt);
            }
        });
        this.addPlotsButton.setAction(this.addPlotsAction);
        this.addPlotsButton.setText("Add Plots...");
        this.addPlotsButton.setToolTipText("Add plots around the focus plot");
        this.fixLayoutButton.setText("Fix Layout");
        this.fixLayoutButton.setToolTipText("Remove gaps and overlaps in vertical stack of plots");
        this.fixLayoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.fixLayoutButtonActionPerformed(evt);
            }
        });
        this.deletePlotButton.setAction(this.deletePlotAction);
        this.deletePlotButton.setText("Delete Plots");
        this.deletePlotButton.setToolTipText("Delete the selected plot(s)");
        this.deletePlotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.deletePlotButtonActionPerformed(evt);
            }
        });
        this.selectedPlotLabel.setFont(this.selectedPlotLabel.getFont().deriveFont((float)this.selectedPlotLabel.getFont().getSize() - 2.0f));
        this.selectedPlotLabel.setText(" ");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.tallerButton, -1, -1, Short.MAX_VALUE).add((Component)this.shorterButton, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.sameHeightButton, -2, 1, Short.MAX_VALUE).add((Component)this.fixLayoutButton, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.addPlotsButton, -1, -1, Short.MAX_VALUE).add((Component)this.deletePlotButton, -2, 1, Short.MAX_VALUE)).add(8, 8, 8)).add((Component)this.canvasLayoutPanel1, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.selectedPlotLabel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.canvasLayoutPanel1, -1, 129, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.selectedPlotLabel).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.tallerButton).add((Component)this.addPlotsButton).add((Component)this.sameHeightButton)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.fixLayoutButton).add((Component)this.shorterButton).add((Component)this.deletePlotButton))));
        this.jSplitPane2.setTopComponent(this.jPanel1);
        this.jSplitPane1.setLeftComponent(this.jSplitPane2);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jSplitPane1, -1, 718, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSplitPane1));
    }

    private void propertiesMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        DasPlot component = (DasPlot)this.canvasLayoutPanel1.getComponent();
        Plot domPlot = this.dom.getController().getPlotFor((Component)component);
        if (domPlot == null) {
            this.dom.getController().setStatus("warning: nothing selected");
            return;
        }
        List<Object> components = this.canvasLayoutPanel1.getSelectedComponents();
        ArrayList<Plot> plots = new ArrayList<Plot>();
        for (int i = 0; i < components.size(); ++i) {
            if (!(components.get(i) instanceof Component)) continue;
            plots.add(this.dom.getController().getPlotFor((Component)components.get(i)));
        }
        if (plots.size() > 1) {
            PropertyEditor edit = PropertyEditor.createPeersEditor((Object)domPlot, (Object[])plots.toArray());
            edit.showDialog((Component)this);
        } else {
            PropertyEditor edit = new PropertyEditor((Object)domPlot);
            edit.showDialog((Component)this);
        }
    }

    private void swapMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        List<Plot> plots = this.getSelectedPlots();
        if (plots.size() == 2) {
            DomOps.swapPosition(plots.get(0), plots.get(1));
            if (this.dom.getOptions().isAutolayout()) {
                DomOps.newCanvasLayout(this.dom);
            }
            this.dom.getController().setStatus("swapped " + plots.get(0) + " and " + plots.get(1));
        } else {
            this.dom.getController().setStatus("warning: select two plots");
        }
    }

    private void addPlotsBelowMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHiddenMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        BindToHiddenDialog dia = new BindToHiddenDialog();
        int op = WindowManager.showConfirmDialog((Component)this, (Object)dia, (String)"Add hidden plot for binding", (int)2, (int)-1);
        if (op == 0) {
            String lock = "Add hidden plot";
            List<Plot> plots = this.getSelectedPlots();
            if (plots.isEmpty()) {
                return;
            }
            this.dom.getController().registerPendingChange(this, "Add hidden plot");
            try {
                AutoRangeUtil.AutoRangeDescriptor ads;
                Object ads2;
                Iterator<Plot> adss;
                this.dom.getController().performingChange(this, "Add hidden plot");
                Column col = DomOps.getOrCreateSelectedColumn(this.dom, this.getSelectedPlots(), true);
                Row row = DomOps.getOrCreateSelectedRow(this.dom, this.getSelectedPlots(), true);
                Plot p = this.dom.getController().addPlot(row, col);
                PlotElement pe = this.dom.getController().addPlotElement(p, null);
                pe.setActive(false);
                p.setVisible(false);
                p.getXaxis().setVisible(false);
                p.getYaxis().setVisible(false);
                Plot[] bottomTopPlots = DomOps.bottomAndTopMostPlot(this.dom, plots);
                if (dia.getxAxisCB().isSelected()) {
                    adss = new ArrayList<AutoRangeUtil.AutoRangeDescriptor>();
                    for (Plot plot : this.getSelectedPlots()) {
                        if (!plot.getXaxis().isVisible()) continue;
                        AutoRangeUtil.AutoRangeDescriptor ads22 = new AutoRangeUtil.AutoRangeDescriptor();
                        ads22.range = plot.getXaxis().getRange();
                        ads22.log = plot.getXaxis().isLog();
                        adss.add((Plot)((Object)ads22));
                    }
                    ads2 = AutoRangeUtil.commonRange(adss);
                    for (Plot p1 : this.getSelectedPlots()) {
                        BindingModel check;
                        p.getXaxis().setRange(((AutoRangeUtil.AutoRangeDescriptor)ads2).range);
                        if (!((AutoRangeUtil.AutoRangeDescriptor)ads2).log) {
                            p1.getXaxis().setLog(((AutoRangeUtil.AutoRangeDescriptor)ads2).log);
                        }
                        if ((check = this.dom.getController().findBinding(this.dom, "timeRange", p1.getXaxis(), "range")) != null) {
                            this.dom.getController().bind(this.dom, "timeRange", p.getXaxis(), "range");
                        } else {
                            this.dom.getController().bind(p.getXaxis(), "range", p1.getXaxis(), "range");
                        }
                        p.getXaxis().setLog(((AutoRangeUtil.AutoRangeDescriptor)ads2).log);
                        this.dom.getController().bind(p.getXaxis(), "log", p1.getXaxis(), "log");
                    }
                }
                if (dia.getyAxisCB().isSelected()) {
                    adss = new ArrayList();
                    for (Plot plot : this.getSelectedPlots()) {
                        if (!plot.getYaxis().isVisible()) continue;
                        ads = new AutoRangeUtil.AutoRangeDescriptor();
                        ads.range = plot.getYaxis().getRange();
                        ads.log = plot.getYaxis().isLog();
                        adss.add((Plot)((Object)ads));
                    }
                    ads2 = AutoRangeUtil.commonRange(adss);
                    p.getYaxis().setRange(((AutoRangeUtil.AutoRangeDescriptor)ads2).range);
                    p.getYaxis().setLog(((AutoRangeUtil.AutoRangeDescriptor)ads2).log);
                    p.getYaxis().setRange(((AutoRangeUtil.AutoRangeDescriptor)ads2).range);
                    for (Plot p1 : this.getSelectedPlots()) {
                        if (((AutoRangeUtil.AutoRangeDescriptor)ads2).log) {
                            p1.getYaxis().setRange(((AutoRangeUtil.AutoRangeDescriptor)ads2).range);
                        }
                        p1.getYaxis().setLog(((AutoRangeUtil.AutoRangeDescriptor)ads2).log);
                        p1.getYaxis().setRange(((AutoRangeUtil.AutoRangeDescriptor)ads2).range);
                        this.dom.getController().bind(p.getYaxis(), "range", p1.getYaxis(), "range");
                        this.dom.getController().bind(p.getYaxis(), "log", p1.getYaxis(), "log");
                    }
                }
                if (dia.getzAxisCB().isSelected()) {
                    adss = new ArrayList();
                    for (Plot plot : this.getSelectedPlots()) {
                        if (!plot.getZaxis().isVisible()) continue;
                        ads = new AutoRangeUtil.AutoRangeDescriptor();
                        ads.range = plot.getZaxis().getRange();
                        ads.log = plot.getZaxis().isLog();
                        adss.add((Plot)((Object)ads));
                    }
                    ads2 = AutoRangeUtil.commonRange((List<AutoRangeUtil.AutoRangeDescriptor>)((Object)adss));
                    p.getZaxis().setRange(((AutoRangeUtil.AutoRangeDescriptor)ads2).range);
                    p.getZaxis().setLog(((AutoRangeUtil.AutoRangeDescriptor)ads2).log);
                    p.getZaxis().setRange(((AutoRangeUtil.AutoRangeDescriptor)ads2).range);
                    for (Plot p1 : this.getSelectedPlots()) {
                        if (((AutoRangeUtil.AutoRangeDescriptor)ads2).log) {
                            p1.getZaxis().setRange(((AutoRangeUtil.AutoRangeDescriptor)ads2).range);
                        }
                        p1.getZaxis().setLog(((AutoRangeUtil.AutoRangeDescriptor)ads2).log);
                        p1.getZaxis().setRange(((AutoRangeUtil.AutoRangeDescriptor)ads2).range);
                        this.dom.getController().bind(p.getZaxis(), "range", p1.getZaxis(), "range");
                        this.dom.getController().bind(p.getZaxis(), "log", p1.getZaxis(), "log");
                    }
                }
                if (dia.getCondenseColorBarsCB().isSelected()) {
                    for (Plot p1 : this.getSelectedPlots()) {
                        this.dom.getController().bind(p, "colortable", p1, "colortable");
                    }
                }
                if (dia.getCondenseColorBarsCB().isSelected()) {
                    p.getZaxis().setVisible(true);
                    for (Plot p1 : plots) {
                        p1.getZaxis().setVisible(false);
                    }
                    p.getZaxis().setVisible(true);
                } else {
                    p.getZaxis().setVisible(false);
                }
                if (dia.getCondenseXAxisLabelsCB().isSelected()) {
                    String t = plots.get(0).getTitle();
                    for (Plot plot : this.getSelectedPlots()) {
                        plot.getXaxis().setDrawTickLabels(false);
                        plot.getXaxis().setLabel("");
                        plot.setTitle("");
                        Row r = this.dom.getCanvases(0).getController().getRowFor(plot);
                        r.setTop(r.getTop().replaceAll("(.*)\\+([\\d\\.]+)em(.*)", "$1+0.5em"));
                        r.setBottom(r.getBottom().replaceAll("(.*)\\-([\\d\\.]+)em", "$1-0.5em"));
                    }
                    bottomTopPlots[1].setTitle(t);
                    bottomTopPlots[0].getXaxis().setDrawTickLabels(true);
                    row.setTop(row.getTop().replaceAll("(.*)\\+([\\d\\.]+)em(.*)", "$1+0.5em"));
                    row.setBottom(row.getBottom().replaceAll("(.*)\\-([\\d\\.]+)em", "$1-0.5em"));
                }
            }
            finally {
                this.dom.getController().changePerformed(this, "Add hidden plot");
            }
        }
    }

    private void deleteBindingsMenuItemActionPerformed(ActionEvent evt) {
        Object[] bindings;
        LoggerManager.logGuiEvent((ActionEvent)evt);
        for (Object o : bindings = this.bindingListComponent.getSelectedValues()) {
            BindingModel b = (BindingModel)o;
            this.dom.getController().removeBinding(b);
        }
    }

    private void plotElementListComponentValueChanged(ListSelectionEvent evt) {
        logger.log(Level.FINE, "panelListComponentValueChanged {0}", evt.getValueIsAdjusting());
        if (!evt.getValueIsAdjusting()) {
            this.selectionChanged = true;
            this.repaint();
        }
    }

    private void fixLayout(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        DomOps.newCanvasLayout(this.dom);
    }

    private void biggerMIActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        ArrayList<Row> rows = new ArrayList<Row>();
        for (Plot p1 : this.getSelectedPlots()) {
            Row row;
            if (!p1.isVisible() || rows.contains(row = p1.getController().getRow())) continue;
            rows.add(row);
        }
        for (Row r : rows) {
            try {
                double[] d1 = DasDevicePosition.parseLayoutStr((String)r.getTop());
                double[] d2 = DasDevicePosition.parseLayoutStr((String)r.getBottom());
                d2[0] = d1[0] + (d2[0] - d1[0]) * 1.25;
                r.setBottom(DasDevicePosition.formatFormatStr((double[])d2));
            }
            catch (ParseException ex) {
                logger.log(Level.INFO, "ParseException ignored: {0}", ex);
            }
        }
        if (this.dom.getOptions().isAutolayout()) {
            DomOps.newCanvasLayout(this.dom);
        }
    }

    private void sameSizeMIActionPerformed(ActionEvent evt) {
        double[] d2;
        double[] d1;
        LoggerManager.logGuiEvent((ActionEvent)evt);
        ArrayList<Row> rows = new ArrayList<Row>();
        for (Plot p1 : this.getSelectedPlots()) {
            Row row;
            if (!p1.isVisible() || rows.contains(row = p1.getController().getRow())) continue;
            rows.add(row);
        }
        double size = 0.0;
        double emMaxTop = 0.0;
        double emMaxBottom = 0.0;
        int n = 0;
        for (Row r : rows) {
            try {
                d1 = DasDevicePosition.parseLayoutStr((String)r.getTop());
                d2 = DasDevicePosition.parseLayoutStr((String)r.getBottom());
                size += d2[0] - d1[0];
                emMaxBottom = Math.max(emMaxBottom, d2[1]);
                emMaxTop = Math.max(emMaxTop, d2[1]);
                ++n;
            }
            catch (ParseException ex) {
                logger.log(Level.INFO, "ParseException ignored: {0}", ex);
            }
        }
        size /= (double)n;
        for (Row r : rows) {
            try {
                d1 = DasDevicePosition.parseLayoutStr((String)r.getTop());
                d2 = DasDevicePosition.parseLayoutStr((String)r.getBottom());
                d2[0] = d1[0] + size;
                d2[1] = emMaxBottom;
                d1[1] = emMaxTop;
                String bottomStr = DasDevicePosition.formatLayoutStr((double[])d2);
                String topStr = DasDevicePosition.formatLayoutStr((double[])d1);
                r.setBottom(bottomStr);
                r.setTop(topStr);
            }
            catch (ParseException ex) {
                logger.log(Level.INFO, "ParseException ignored: {0}", ex);
            }
        }
        if (this.dom.getOptions().isAutolayout()) {
            DomOps.newCanvasLayout(this.dom);
        }
    }

    private void smallerMIActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        ArrayList<Row> rows = new ArrayList<Row>();
        for (Plot p1 : this.getSelectedPlots()) {
            Row row;
            if (!p1.isVisible() || rows.contains(row = p1.getController().getRow())) continue;
            rows.add(row);
        }
        for (Row r : rows) {
            try {
                double[] d1 = DasDevicePosition.parseLayoutStr((String)r.getTop());
                double[] d2 = DasDevicePosition.parseLayoutStr((String)r.getBottom());
                d2[0] = d1[0] + (d2[0] - d1[0]) * 0.8;
                r.setBottom(DasDevicePosition.formatFormatStr((double[])d2));
            }
            catch (ParseException ex) {
                logger.log(Level.INFO, "ParseException ignored: {0}", ex);
            }
        }
        if (this.dom.getOptions().isAutolayout()) {
            DomOps.newCanvasLayout(this.dom);
        }
    }

    private void deletePlotButtonActionPerformed(ActionEvent evt) {
    }

    private void sameHeightButtonActionPerformed(ActionEvent evt) {
        this.sameSizeMIActionPerformed(evt);
    }

    private void shorterButtonActionPerformed(ActionEvent evt) {
        this.smallerMIActionPerformed(evt);
    }

    private void tallerButtonActionPerformed(ActionEvent evt) {
        this.biggerMIActionPerformed(evt);
    }

    private void fixLayoutButtonActionPerformed(ActionEvent evt) {
        this.fixLayout(evt);
    }

    private void dataSourceListValueChanged(ListSelectionEvent evt) {
        String s = this.dataSourceList.getSelectedValue();
        if (s instanceof DataSourceFilter) {
            this.dom.getController().setDataSourceFilter((DataSourceFilter)((Object)s));
            this.dom.getController().setFocusUri(((DataSourceFilter)((Object)s)).getUri());
            List<PlotElement> pes = DomUtil.getPlotElementsFor(this.dom, (DataSourceFilter)((Object)s));
            if (pes.size() > 0 && !pes.contains((PlotElement)this.plotElementListComponent.getSelectedValue())) {
                this.dom.getController().setPlotElement(pes.get(0));
            }
        }
    }

    private void editMenuItemActionPerformed(ActionEvent evt) {
        String s = this.dataSourceList.getSelectedValue();
        if (s instanceof DataSourceFilter) {
            this.dom.getController().setDataSourceFilter((DataSourceFilter)((Object)s));
            this.dom.getController().setFocusUri(((DataSourceFilter)((Object)s)).getUri());
            String uri = ((DataSourceFilter)((Object)s)).getUri();
            if (uri.startsWith("vap+internal:")) {
                GuiSupport.editPlotElement(this.applicationModel, this);
            } else if (uri.length() == 0) {
                JPanel parent = new JPanel();
                parent.setMinimumSize(new Dimension(600, 400));
                parent.setPreferredSize(new Dimension(600, 400));
                parent.setLayout(new BorderLayout());
                DataSetSelector sss = new DataSetSelector();
                sss.setRecent(AutoplotUtil.getUrls(this.applicationModel.getRecent()));
                parent.add((Component)sss, "North");
                if (0 == AutoplotUtil.showConfirmDialog(this, parent, "Edit URI for " + ((DataSourceFilter)((Object)s)).getId(), 2)) {
                    uri = sss.getValue();
                    try {
                        DataSourceEditorPanel x = DataSourceEditorPanelUtil.getDataSourceEditorPanel((JPanel)parent, (String)uri);
                        ((DataSourceFilter)((Object)s)).setUri(uri);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            } else {
                JPanel parent = new JPanel();
                parent.setLayout(new BorderLayout());
                DataSourceEditorPanel p = DataSourceEditorPanelUtil.getDataSourceEditorPanel((JPanel)parent, (String)uri);
                if (0 == AutoplotUtil.showConfirmDialog(this, parent, "Edit " + ((DataSourceFilter)((Object)s)).getId(), 2)) {
                    uri = p.getURI();
                    ((DataSourceFilter)((Object)s)).setUri(uri);
                }
            }
        }
    }

    private void setHeightMIActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        double emHeight = 1.0;
        ArrayList<Row> rows = new ArrayList<Row>();
        for (Plot p1 : this.getSelectedPlots()) {
            Row row;
            if (!p1.isVisible() || rows.contains(row = p1.getController().getRow())) continue;
            rows.add(row);
        }
        for (Row r : rows) {
            try {
                double[] d1 = DasDevicePosition.parseLayoutStr((String)r.getTop());
                double[] d2 = DasDevicePosition.parseLayoutStr((String)r.getBottom());
                d2[0] = d1[0];
                d2[1] = d1[1] + emHeight;
                d2[2] = 0.0;
                r.setBottom(DasDevicePosition.formatFormatStr((double[])d2));
            }
            catch (ParseException ex) {
                logger.log(Level.INFO, "ParseException ignored: {0}", ex);
            }
        }
    }

    private void deleteAnnotationsMenuItemActionPerformed(ActionEvent evt) {
        Object[] annotations;
        LoggerManager.logGuiEvent((ActionEvent)evt);
        for (Object o : annotations = this.annotationsListComponent.getSelectedValues()) {
            Annotation a = (Annotation)o;
            this.dom.getController().deleteAnnotation(a);
        }
    }

    private void editAnnotationsMenuItemActionPerformed(ActionEvent evt) {
        PropertyEditor edit;
        Object[] annotations = this.annotationsListComponent.getSelectedValues();
        switch (annotations.length) {
            case 0: {
                return;
            }
            case 1: {
                edit = new PropertyEditor(annotations[0]);
                break;
            }
            default: {
                Object[] peers = new Annotation[annotations.length];
                System.arraycopy(annotations, 0, peers, 0, annotations.length);
                edit = PropertyEditor.createPeersEditor((Object)this.annotationsListComponent.getSelectedValue(), (Object[])peers);
            }
        }
        edit.showDialog((Component)this);
    }

    private void plotListComponentValueChanged(ListSelectionEvent evt) {
        logger.log(Level.FINE, "panelListComponentValueChanged {0}", evt.getValueIsAdjusting());
        if (!evt.getValueIsAdjusting()) {
            this.selectionChanged = true;
            Plot selected = this.plotListComponent.getSelectedValue();
            if (selected != null) {
                this.dom.getController().setPlot(selected);
            }
            this.repaint();
        }
    }
}

